﻿//////////////////////////////////////////////
// HuffmanLut.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include "../Dll/DllDefines.h"

#include "../Containers/BufferCast.h"
#include "../Containers/BufferView.h"

/// Internals --------------------------------

namespace nkMemory
{
	struct HuffmanTreeDescriptor final
	{
		BufferCast<unsigned short> _table ;
		unsigned char _perBitsCounts [16] = {0u} ;
	} ;

	struct HuffmanSymbol final
	{
		unsigned short _size = 0 ;
		unsigned short _value = 0 ;
	} ;
}

/// Class ------------------------------------

namespace nkMemory
{
	class DLL_MEMORY_EXPORT HuffmanLut
	{
		public :

			// Constructor, destructor
			HuffmanLut (const HuffmanTreeDescriptor& descriptor) noexcept ;
			HuffmanLut (nkMemory::BufferView<unsigned short> canonicalDescription) noexcept ;

			// Getters
			BufferView<HuffmanSymbol> getLut () const ;
			HuffmanSymbol get (unsigned int input) const ;
			unsigned int getLutSize () const ;
			unsigned int getMaxSymbolSize () const ;

		private :

			// Build
			void _buildLut (const HuffmanTreeDescriptor& descriptor) ;

		private :

			BufferCast<HuffmanSymbol> _lut ;
			unsigned int _lutSize ;
			unsigned int _maxSymbolSize ;
	} ;
}